//******************************************************
//* jonboy_sprite.js
//******************************************************

// Constants - Types of sprites (major types)
var MAJT_ASTEROID = 1;
var MAJT_SHIP = 2;
var MAJT_BULLET = 3;
var MAJT_POWERUP = 4;
var MAJT_EXPLOSION = 5;
// Constants - Sprite races 
var SRACE_GOOMBA = 11;
var SRACE_KOOPA = 22;
var SRACE_BUZZY = 33;
var SRACE_BOWSER = 44;
var SRACE_CLOUD = 55;
var SRACE_BILL = 66;
var SRACE_QBLOCK = 333;
var SRACE_MARIO = 444;
// Constants - Sprite "colors"
var SCOL_GREEN = 10;
var SCOL_RED = 20;
var SCOL_BLUE = 30;
var SCOL_GREY = 40;
// Constants - Sprite sizes 
var SSIZE_BIG = 64;
var SSIZE_SMALL = 48;
var SSIZE_TINY = 32;
// Constants - Speed, rotation and animation ranges by size
var SSIZE_BIG_SPEED_MAX = 40;
var SSIZE_BIG_SPEED_MIN = 20;
var SSIZE_BIG_ROTATE_MAX = 10;
var SSIZE_BIG_ROTATE_MIN = 2;
var SSIZE_BIG_FRAMEDELAY_MAX = 20;
var SSIZE_BIG_FRAMEDELAY_MIN = 16;
var SSIZE_SMALL_SPEED_MAX = 120;
var SSIZE_SMALL_SPEED_MIN = 60;
var SSIZE_SMALL_ROTATE_MAX = 20;
var SSIZE_SMALL_ROTATE_MIN = 4;
var SSIZE_SMALL_FRAMEDELAY_MAX = 16;
var SSIZE_SMALL_FRAMEDELAY_MIN = 12;
var SSIZE_TINY_SPEED_MAX = 360;
var SSIZE_TINY_SPEED_MIN = 180;
var SSIZE_TINY_ROTATE_MAX = 40;
var SSIZE_TINY_ROTATE_MIN = 6;
var SSIZE_TINY_FRAMEDELAY_MAX = 12;
var SSIZE_TINY_FRAMEDELAY_MIN = 8;
// Constants - Score
var SCORE_BASE = 25;
// Constants - Die states
var DIESTATE_GOOD = 1;
var DIESTATE_BAD = 2;
// Constants - Koopa hide-in-shell
KOOPA_HIDE_TICKS = 3;
// Preloaded Sounds
var SND_breakblock = LoadSound("breakblock.wav");
var SND_musicdie = LoadSound("music_die.wav");
var SND_oneup = LoadSound("oneup.wav");
var SND_powerup = LoadSound("powerup.wav");
var SND_shellkick = LoadSound("shellkick.wav");
var SND_shroomstomp = LoadSound("shroomstomp.wav");
// Preloaded Spritesets
var SSbulletmario8 = LoadSpriteset("bulletmario8.rss")
var SSgoomba32 = LoadSpriteset("goomba32.rss")
var SSgoomba48 = LoadSpriteset("goomba48.rss")
var SSgoomba64 = LoadSpriteset("goomba64.rss")
var SSkoopablue32 = LoadSpriteset("koopablue32.rss")
var SSkoopablue48 = LoadSpriteset("koopablue48.rss")
var SSkoopablue64 = LoadSpriteset("koopablue64.rss")
var SSkoopagreen32 = LoadSpriteset("koopagreen32.rss")
var SSkoopagreen48 = LoadSpriteset("koopagreen48.rss")
var SSkoopagreen64 = LoadSpriteset("koopagreen64.rss")
var SSkoopagrey32 = LoadSpriteset("koopagrey32.rss")
var SSkoopagrey48 = LoadSpriteset("koopagrey48.rss")
var SSkoopagrey64 = LoadSpriteset("koopagrey64.rss")
var SSkoopagrey32sh = LoadSpriteset("koopagrey32sh.rss")
var SSkoopagrey48sh = LoadSpriteset("koopagrey48sh.rss")
var SSkoopagrey64sh = LoadSpriteset("koopagrey64sh.rss")
var SSkoopared32 = LoadSpriteset("koopared32.rss")
var SSkoopared48 = LoadSpriteset("koopared48.rss")
var SSkoopared64 = LoadSpriteset("koopared64.rss")
var SSkoopared32sh = LoadSpriteset("koopared32sh.rss")
var SSkoopared48sh = LoadSpriteset("koopared48sh.rss")
var SSkoopared64sh = LoadSpriteset("koopared64sh.rss")
var SSmario24 = LoadSpriteset("mario24.rss")
var SSmario24dead = LoadSpriteset("mario24dead.rss")
var HIDE_MAX = 120;

function jonboy_sprite(CommonName, X, Y, Direction, Speed, RotateFace, RotateSpeed, MajorType, SpriteRace, SpriteSize, SpriteColor, Frame, FrameDelay, FrameMax) {
  // Ensure whatever is returned is an actual instance of a class
  if ( !(this instanceof jonboy_sprite) ) return new jonboy_sprite();
  // DIRECTION (and "FACE") expressed in RADIUS!!!
  var _ID = NewObjID();
  var _name = CommonName;
  var _direction = Direction;
  var _speed = Speed;
  var _X = X;
  var _Y = Y;
  var _majortype = MajorType;  // Used to determine whether or not to run collision tests
  var _spritesize = SpriteSize;  // Used to determine score and "breaks"
  var _spriterace = SpriteRace;  
  var _spritecolor = SpriteColor;  
  var _rotateface = RotateFace;  
  var _rotatespeed = RotateSpeed;  
  var _frame = Frame;  
    var _frametick = 0;
  var _framedelay = FrameDelay;  
  var _framemax = FrameMax;  
  var _hiding = 0;
  // var _spriteset = LoadSpriteset(SpriteSet);
//  var _spriteset = LoadSpriteset(CalcSpriteset(_majortype,_spriterace,_spritesize,_spritecolor));
  var _spriteset = CalcSpriteset(_majortype,_spriterace,_spritesize,_spritecolor);
  var _rectX1 = _spriteset.base.x1;
  var _rectX2 = _spriteset.base.x2;
  var _rectY1 = _spriteset.base.y1;
  var _rectY2 = _spriteset.base.y2;
  var _roundX = Math.round((_spriteset.base.x1+_spriteset.base.x2)/2);
  var _roundY = Math.round((_spriteset.base.y1+_spriteset.base.y2)/2);
  var _roundRadius = Math.round((_spriteset.base.y2-_spriteset.base.y1)/2);

  // READ ONLY Properties
  this.dead = false;
  this.ID = _ID;
  this.name = _name;
  this.X = Math.floor(_X);
  this.Y = Math.floor(_Y);
  this.speed = _speed;
  this.direction = _direction;
  this.roundRadius = _roundRadius;
  this.rectX1 = _rectX1;
  this.rectX2 = _rectX2;
  this.rectY1 = _rectY1;
  this.rectY2 = _rectY2;
  this.roundX = _roundX;
  this.roundY = _roundY;
  this.rectX1abs = this.X + this.rectX1;
  this.rectX2abs = this.X + this.rectX2;
  this.rectY1abs = this.Y + this.rectY1;
  this.rectY2abs = this.Y + this.rectY2;
  this.majortype = _majortype;
  this.spritesize = _spritesize;
  this.spriteset = _spriteset;
  this.spriterace = _spriterace;
  this.spritecolor = _spritecolor;
  this.rotateface = _rotateface;  
  this.rotatespeed = _rotatespeed;    

  // READ/WRITE Properties
  this.direction_set = function(arg1){_direction = arg1; this.direction = _direction;};
  this.speed_set = function(arg1){_speed = arg1; this.speed = _speed;};
  this.majortype_set = function(arg1){_majortype = arg1;  this.majortype = _majortype;};
  this.minortype_set = function(arg1){_minortype = arg1;  this.minortype = _minortype;};
  this.spritesize_set = function(arg1){_spritesize = arg1;  this.spritesize = _spritesize;};
  this.spriteset_set = function(arg1){_spriteset = arg1;  this.spriteset = _spriteset;};
  this.X_set = function(arg1){_X = Math.floor(arg1); this.X=_X;};
  this.Y_set = function(arg1){_Y = Math.floor(arg1); this.Y=_Y;};
  this.roundRadius_set = function(arg1){_roundRadius = Math.floor(arg1); this.roundRadius = _roundRadius;};
  this.rotateface_add = function(arg1){_rotateface = _rotateface + arg1; this.rotateface = _rotateface;};
  this.rotateface_subtract = function(arg1){_rotateface = _rotateface - arg1; this.rotateface = _rotateface;};
  this.rotateface_set = function(arg1){_rotateface = arg1;  this.rotateface = _rotateface;};
  this.rotatespeed_set = function(arg1){_rotatespeed = arg1;  this.rotatespee = _rotatespeed;};

  // Functions  
  var SectX1Y1;
  var BumpX, BumpY;
  
  this.registerinsectors = function(tempnum) {
    BumpX = false;
    BumpY = false;
    SectX = Math.floor(this.rectX1abs/ctest_sector_width);
    SectY = Math.floor(this.rectY1abs/ctest_sector_height);
    SectX1Y1 = SectX + (SectY * ctest_Xsectors);   
//     jdw(10,"Sprite #" + tempnum + ": SectX=" + SectX + " SectY=" + SectY + " SectX1Y1=" + SectX1Y1);
    ctest_sector_sprite[SectX1Y1][ctest_sector_spritecount[SectX1Y1]] = tempnum;	
    ctest_sector_spritecount[SectX1Y1]++;		
    // Check "one over"
    if (this.rectX2abs > ((SectX + 1) * ctest_sector_width)) {
      if (this.rectX2abs < CONST_VIEW_WIDTH) {
        ctest_sector_sprite[SectX1Y1+1][ctest_sector_spritecount[SectX1Y1+1]] = tempnum;	
        ctest_sector_spritecount[SectX1Y1+1]++;		
        BumpX = true;
      }
    }
    // Check "one down"
    if (this.rectY2abs > ((SectY + 1) * ctest_sector_height)) {
      if (this.rectY2abs < CONST_VIEW_HEIGHT) {
        ctest_sector_sprite[SectX1Y1+ctest_Xsectors][ctest_sector_spritecount[SectX1Y1+ctest_Xsectors]] = tempnum;	
        ctest_sector_spritecount[SectX1Y1+ctest_Xsectors]++;		
        BumpY = true;
      }
    }
    if (BumpX && BumpY) {
        ctest_sector_sprite[SectX1Y1+ctest_Xsectors+1][ctest_sector_spritecount[SectX1Y1+ctest_Xsectors+1]] = tempnum;	
        ctest_sector_spritecount[SectX1Y1+ctest_Xsectors+1]++;		    
    }
  }
  
  this.update = function(){
    var z = _speed/60;  
    var x = z * Math.cos(_direction);
    var y = z * Math.sin(_direction);
    _X = _X + x;
    _Y = _Y + y;
    // Do rotation and animation
    _rotateface = _rotateface + (_rotatespeed/10);
    while (_rotateface<0) { _rotateface = _rotateface+Math.PI*2;}
    while (_rotateface>=Math.PI*2) { _rotateface = _rotateface-Math.PI*2;}
    if (_majortype == MAJT_SHIP) {
      _frame = 0;
      if (MarioIsDead) {
        _speed = _speed - 10;
      } else {
        // Animate spitting fire
        if (MarioFireFade > 0) {
          MarioFireFade = MarioFireFade - 1;
          _frame = _frame + 1;
        }
        // Keep "ship" right-side up
        if ((_rotateface<(Math.PI*3/2)) && (_rotateface>(Math.PI/2))) {
          _frame = _frame + 2;
        }  
      }
    } else {
      // Not a ship - standard animation
      _frametick = _frametick + 1;
      if (_frametick >= _framedelay) {
        _frame = _frame + 1;
        _frametick = 0;
        if (_frame >= _framemax) {
          _frame = 0;
        }
      }
    }

    // Animate hiding goomba?
    if ((_spriterace==SRACE_KOOPA) && ( (_spritecolor==SCOL_RED) || (_spritecolor==SCOL_GREY) )) {
      if (_hiding>0) {
        if (_hiding==HIDE_MAX) {
          switch (_spritecolor) {
            case SCOL_RED:
              switch (_spritesize) {
                case SSIZE_BIG: _spriteset=SSkoopared64sh; break;
                case SSIZE_SMALL: _spriteset=SSkoopared48sh; break;
                case SSIZE_TINY: _spriteset=SSkoopared32sh; break;
              }
              break;
            case SCOL_GREY:
              switch (_spritesize) {
                case SSIZE_BIG: _spriteset=SSkoopagrey64sh; break;
                case SSIZE_SMALL: _spriteset=SSkoopagrey48sh; break;
                case SSIZE_TINY: _spriteset=SSkoopagrey32sh; break;
              }
              break;
          }
        }
        if (_hiding==1) {
          _spriteset = CalcSpriteset(_majortype,_spriterace,_spritesize,_spritecolor);
        }
        _hiding--;
      } 
    }

    if (_majortype == MAJT_BULLET) {
      // Destroy sprite?
      if ( (_X < 0) || (_X >= CONST_VIEW_WIDTH) || (_Y < 0) || (_Y >= CONST_VIEW_HEIGHT) ) {
//        jdw(1,"Destroying bullet that went off-screen.");
	if (_spriterace == SRACE_MARIO) { MarioBulletCount--; }
        this.dead = true;
      }
    } else {
      // Don't wrap a dead mario!
      if ((_majortype == MAJT_SHIP) && (MarioIsDead)) {
        if (_X < 0) {_X=0;}
        if (_X >= CONST_VIEW_WIDTH) {_X=CONST_VIEW_WIDTH-1;}
        if (_Y < 0) {_Y=0;}
        if (_Y >= CONST_VIEW_HEIGHT) {_Y=CONST_VIEW_HEIGHT-1;}        
      } else {
        // "Wrap" other sprites around screen
        if (_X < 0) {_X=_X + CONST_VIEW_WIDTH;}
        if (_X >= CONST_VIEW_WIDTH) {_X=_X - CONST_VIEW_WIDTH;}
        if (_Y < 0) {_Y=_Y + CONST_VIEW_HEIGHT;}
        if (_Y >= CONST_VIEW_HEIGHT) {_Y=_Y - CONST_VIEW_HEIGHT;}
      }
    }
      this.X = Math.floor(_X);
      this.Y = Math.floor(_Y);
      this.rectX1abs = this.X + this.rectX1;
      this.rectX2abs = this.X + this.rectX2;
      this.rectY1abs = this.Y + this.rectY1;
      this.rectY2abs = this.Y + this.rectY2;
      //jdw(10,"New values: _X:" + _X + ", _Y:" + _Y);  

  };

  this.render = function(){
//    jdw(10,"Render values: this.X:" + this.X + ", this.Y:" + this.Y);  
//    _spriteset.images[0].blit(this.X,this.Y);
    try {
//      _spriteset.images[0].blit(Math.floor(_X),Math.floor(_Y)+HEAD_HEIGHT);
//      _spriteset.images[0].rotateBlit(Math.floor(_X),Math.floor(_Y)+HEAD_HEIGHT,degreetorad(_rotateface));
//      _spriteset.images[_frame].rotateBlit(Math.floor(_X),Math.floor(_Y)+HEAD_HEIGHT,degreetorad(_rotateface));
//      _spriteset.images[_frame].rotateBlit(Math.floor(_X),Math.floor(_Y)+HEAD_HEIGHT,_rotateface);
      _spriteset.images[_frame].rotateBlit(Math.floor(_X)-HEAD_HEIGHT,Math.floor(_Y)+HEAD_HEIGHT,_rotateface);
    } catch(e) {
      jdw(1,"Error: #" + e.number + " " + e.description);
      jdw(1,"Render error _spriteset.images[0].blit(Math.floor(" + _X +  "),Math.floor(" + _Y +  "))");
    };
  }
  
  // Method called when this sprite dies
  this.die = function(DieState, Silent) {
    switch(_majortype) {
      case MAJT_ASTEROID:
        break;
      case MAJT_SHIP:
        break;
      // case MAJT_BULLET:  (Bullets just die...their targets do not!)
      case MAJT_POWERUP:
        switch(_minortype) {
          case MINT_POWER1UP:
            SND_oneup.play();
            break;
          case MINT_POWERSHROOM:
            SND_powerup.play();
            break;
          case MINT_POWERSTAR:
            SND_powerup.play();
            break;
          case MINT_POWERFLOWER:          
            SND_powerup.play();
            break;
        }
        break;
    }
  }
  
  // Method to handle collisions - argument passed is other sprite
  this.collide = function(other){
    // jdw(1,"Processing collision between type=" + _majortype + " and type=" + SpriteArr[other].majortype);
    if ( (this.dead) || (SpriteArr[other].dead) ) {
      // One sprite is already dead!
      // jdw(1,"Sorry, one sprite involved in this collision is already dead!");
    } else {
      switch (_majortype) {
        case MAJT_ASTEROID:
          switch (SpriteArr[other].majortype){
            case MAJT_SHIP:
                if (!MarioIsDead){
                  MarioIsDead = true;
                  if (SND_Music.isPlaying()) {
                    SND_Music.stop();
                  }
		  SND_musicdie.play(false);  
		  MarioLives--;
		  SpriteArr[MarioSpriteNum].rotateface_set(0);
		  SpriteArr[MarioSpriteNum].rotatespeed_set(0);
		  SpriteArr[MarioSpriteNum].direction_set(Math.PI*3/2);
  		  SpriteArr[MarioSpriteNum].speed_set(240);
  		  SpriteArr[MarioSpriteNum].spriteset_set(SSmario24dead);
                }
		break;            
            case MAJT_BULLET:
//              jdw(1,"Hit an asteroid!")
              if (SpriteArr[other].spriterace == SRACE_MARIO) { 
                SpriteArr[other].dead = true;
                MarioBulletCount--; 
//                if ((HitOnVulnerableSide(_spriterace,_rotateface,SpriteArr[other].direction)) && (_hiding==0)) {
                if (HitOnVulnerableSide(_spriterace,_rotateface,SpriteArr[other].direction)) {                
		if ((_hiding > 0) && (_spritecolor = SCOL_RED)) {
                  this.shove(SpriteArr[other].direction,96);		  
		} else {
                  this.dead = true;
                  switch (_spritesize) {
                    case SSIZE_BIG:
                      if (SND_shellkick.isPlaying) { SND_shellkick.stop(); } 
                      SND_shellkick.play(false);
		      // MakeSmallAsteroids(Name,BulletDir,sX,sY,sSize,sRace,sColor
		      MakeSmallAsteroids(_name,SpriteArr[other].direction,_X,_Y,SSIZE_SMALL,_spriterace,_spritecolor);
		      break;
                    case SSIZE_SMALL:
                      if (SND_shellkick.isPlaying) { SND_shellkick.stop(); } 
                      SND_shellkick.play(false);
		      // MakeSmallAsteroids(Name,BulletDir,sX,sY,sSize,sRace,sColor
		      MakeSmallAsteroids(_name,SpriteArr[other].direction,_X,_Y,SSIZE_TINY,_spriterace,_spritecolor);
		      break;
                    case SSIZE_TINY:
                      if (SND_breakblock.isPlaying) { SND_breakblock.stop(); } 
                      SND_breakblock.play(false);
                      break;
                  }
                  MarioScore = MarioScore + GetAsteroidScore(_spriterace,_spritecolor,_spritesize);
		} // End of _hiding, red IF
                } else {
                  switch (_spritecolor) {
                    case SCOL_GREEN:
                      this.shove(SpriteArr[other].direction,96);
                      break;
                    case SCOL_RED:
                      this.shove(SpriteArr[other].direction,60);
                      _hiding = HIDE_MAX;
                      break;
                    case SCOL_BLUE:
                      break;
                    case SCOL_GREY:
                      _hiding = HIDE_MAX;
                      break;
                  }
                }
              }
              break;
          }
        case MAJT_BULLET:
          break;
        default:  break;
      }
    }
  }
  
  // Method to handle "shoves" in a particular direction
  // (Hides vector math!) 
  this.shove = function(newdir,impact){
    // Convert current speed and direction into a vector
    var currX = _speed * Math.cos(_direction);
    var currY = _speed * Math.sin(_direction);
    var newX = impact * Math.cos(newdir);
    var newY = impact * Math.sin(newdir);
//    jdw(1,"vectors: " + currX + ":" + currY + " " + newX + ":" + newY);
    var finalX = currX + newX;    
    var finalY = currY + newY;    
    _speed = Math.sqrt(finalX*finalX+finalY*finalY)
    if ((_majortype == MAJT_SHIP) && (_speed > MAX_MARIOSPEED)) {
      _speed = MAX_MARIOSPEED;
    }
//    jdw(1,"new speed: " + _speed);
    this.speed = _speed;
    _direction = Math.atan(finalY/finalX);
//    if ((_rotateface>(Math.PI*1/2)) && (_rotateface<(Math.PI*3/2))) {
    if (finalX<0) {
      _direction = (_direction + Math.PI);
    }
    this.direction = _direction;    
  }  
  
}

// Determines if the enemy was hit on a vulnerable side
function HitOnVulnerableSide(Race,Face,Dir){
  var RelFace = Dir-Face;
  var HitGood = false;
  while (RelFace<0) {RelFace=RelFace+(2*Math.PI);}
  while (RelFace>(2*Math.PI)) {RelFace=RelFace-(2*Math.PI);}
  switch (Race){
    case SRACE_KOOPA:
      if ((RelFace >= (Math.PI * 5/4)) || (RelFace <= (Math.PI * 1/4))) {
        HitGood = true;
      }
      break;
    case SRACE_BUZZY:
      if (RelFace >= (Math.PI * 3/2))  {
        HitGood = true;
      }
      break;
    default: HitGood=true; break;

  }
  return HitGood;
}

function radtodegree(radval){
  return (radval*180/Math.PI);
}

function degreetorad(degval){
  return (degval*Math.PI/180);
}

// Returns a 12-char string representing an object ID
// (Approximately 95,428,956,661,682,176 possible combos!)
function NewObjID() {
    var NewID = "";
    var i;
    for (i=0;i<12;i++) {
      NewID = NewID + CreateStringFromCode(Math.floor(Math.random()*26) + 65);  
    }
//    jdw(10,"Generated new ID:" + NewID);
    return NewID;
}

/*
function CalcSpriteset(Major,Race,Size,Color) {
  var SSName = "";
  switch(Major){
    case MAJT_ASTEROID:
      switch(Race) {
        case SRACE_GOOMBA: SSName = SSName + "goomba"; break;
        case SRACE_KOOPA: SSName = SSName + "koopa"; break;
        case SRACE_BUZZY: SSName = SSName + "buzzy"; break;
        case SRACE_BOWSER: SSName = SSName + "bowser"; break;
        // default: jdw(6,"CalcSpriteset: Recognized MAJOR: " + Major + " but failed RACE:" + Race); break;
      }      
      switch(Color) {
        case SCOL_GREEN: SSName = SSName + "green"; break;
        case SCOL_BLUE: SSName = SSName + "blue"; break;
        case SCOL_RED: SSName = SSName + "red"; break;
        case SCOL_GREY: SSName = SSName + "grey"; break;
        // default: jdw(6,"CalcSpriteset: Recognized MAJOR: " + Major + " but failed COLOR:" + Color); break;
      }      
      SSName = SSName + Size;
      break;
    case MAJT_SHIP: SSName = "mario24"; break;
    case MAJT_BULLET: 
      switch(Race) {
        case SRACE_MARIO: SSName = "bulletmario8"; break;
//        default: jdw(6,"CalcSpriteset: Recognized MAJOR: " + Major + " but failed RACE:" + Race); break;
      }
//    default: jdw(2,"CalcSpriteset: Unrecognized MAJOR: " + Major); break;
  }
  SSName = SSName + ".rss";
//  jdw(10,"Detected spriteset: " + SSName);
  return SSName;
}
*/
// Now returns the actual preloaded spriteset
function CalcSpriteset(Major,Race,Size,Color) {
  switch(Major){
    case MAJT_ASTEROID:
      switch(Race) {
        case SRACE_GOOMBA: 
              switch(Size){
                case 32: return SSgoomba32
                case 48: return SSgoomba48
                case 64: return SSgoomba64
              } break;
        case SRACE_KOOPA: 
          switch(Color) {
            case SCOL_GREEN:
              switch(Size){
                case 32: return SSkoopagreen32
                case 48: return SSkoopagreen48
                case 64: return SSkoopagreen64
              } break;
            case SCOL_RED:
              switch(Size){
                case 32: return SSkoopared32
                case 48: return SSkoopared48
                case 64: return SSkoopared64
              } break;
            case SCOL_BLUE:
              switch(Size){
                case 32: return SSkoopablue32
                case 48: return SSkoopablue48
                case 64: return SSkoopablue64
              } break;
            case SCOL_GREY:
              switch(Size){
                case 32: return SSkoopagrey32
                case 48: return SSkoopagrey48
                case 64: return SSkoopagrey64
              } break;  // End of color
          } break;  // End of race
      } break; // End of MAJOR TYPE
    case MAJT_SHIP: return SSmario24; break;
    case MAJT_BULLET: 
      switch(Race) {
        case SRACE_MARIO: return SSbulletmario8; break;
      } break; // End of MAJOR TYPE
  }
}

function GetAsteroidScore(Race,Color,Size) {
  var theScore = SCORE_BASE;
  switch (Race) {
    case SRACE_KOOPA: theScore = theScore * 2; break;
    case SRACE_BUZZY: theScore = theScore * 4; break;
    default: break;
  }
  switch (Color) {
    case SCOL_RED: theScore = theScore * 2; break;
    case SCOL_BLUE: theScore = theScore * 2; break;
    case SCOL_GREY: theScore = theScore * 4; break;
    default: break;
  }
  switch (Size) {
    case SSIZE_SMALL: theScore = theScore * 2; break;
    case SSIZE_TINY: theScore = theScore * 4; break;
    default: break;
  }
//  jdw(1,"Calc'ed score: " + theScore);
  return theScore;
}